CREATE OR REPLACE FORCE VIEW "W83B"."W83BDELEGPORCONVDETCENHIST" ("SECTOR", "DESCSECTOR", "NCENTRO", "CIF", "RAZON", "NACTA", "ANOACTA", "TERRIT", "VER", "TOTALELECTORES", "CODSINDICATO", "SIGLAS", "CODCONVENIO", "CONVDESC", "CONVDESE", "FELEC", "FECHAREGISTRO", "TOTALVOTOS", "NUMDELEGADOS", "NACTACOMPLETA", "FECHABAJA", "FECHAACTU") AS 
SELECT   consulta.sector, consulta.descsector, consulta.centro,
            consulta.empresa, consulta.razon, consulta.nacta,
            consulta.anoacta, consulta.territ, consulta.ver,
            consulta.totalelectores, consulta.codsindicato, consulta.siglas,
            consulta.codconvenio, consulta.descconvenio,
            consulta.deseconvenio, consulta.fechaeleccion,
            consulta.fecharegistro,
            NVL ((SELECT SUM (papeletas.vota_044)
                    FROM w83b44s00 papeletas
                   WHERE consulta.nacta = papeletas.n_acta_044
                     AND consulta.anoacta = papeletas.ano_acta_044
                     AND consulta.territ = papeletas.c_territ_044
                     AND consulta.ver = papeletas.version_044),
                 0
                ) AS numvotos,
            consulta.numdelegados, consulta.nactacompleta, consulta.fechabaja,
            consulta.factu
       FROM (SELECT   centros.secc_001 AS sector,
                      sectores.desc_004 AS descsector,
                      centros.ccen_001 AS centro, centros.ccif_001 AS empresa,
                      centros.rsoc_001 AS razon, actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      totelec_016 AS totalelectores,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.siglas_019 AS siglas,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      actas.f_elecc_016 AS fechaeleccion,
                      actas.fregdef_016 AS fecharegistro, 0 AS numvotos,
                      SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024
                          ) AS numdelegados,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta,
                      actas.f_baja_016 AS fechabaja, actas.factu_016 AS factu
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b19s00 sindicatos,
                      w83b13s00 convenios,
                      w83b24s00 escrutinios,
                      j7304s00 sectores
                WHERE centros.ccen_001 = actas.id_centro_016
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND actas.n_acta_016 = escrutinios.n_acta_024
                 AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND centros.secc_001 = sectores.secc_004
                  AND actas.validada_016 = 1
                  --AND actas.f_baja_016 IS NULL
                  AND actas.n_acttot_016 IS NULL
                AND actas.n_regdef_016 IS NOT NULL
                  AND actas.fregdef_016 IS NOT NULL
             GROUP BY centros.secc_001,
                      sectores.desc_004,
                      centros.ccen_001,
                      centros.ccif_001,
                      centros.rsoc_001,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      totelec_016,
                      sindicatos.c_sindi_019,
                      sindicatos.siglas_019,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016,
                      actas.factu_016
             UNION ALL
             SELECT   centros.secc_001 AS sector,
                      sectores.desc_004 AS descsector,
                      centros.ccen_001 AS centro, centros.ccif_001 AS empresa,
                      centros.rsoc_001 AS razon, actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      totelec_016 AS totalelectores,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.siglas_019 AS siglas,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      actas.f_elecc_016 AS fechaeleccion,
                      actas.fregdef_016 AS fecharegistro, 0 AS numvotos,
                      SUM (diferencias.n_delm_018 + diferencias.n_delh_018
                          ) AS numdelegados,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta,
                      actas.f_baja_016 AS fechabaja, actas.factu_016 AS factu
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b19s00 sindicatos,
                      w83b13s00 convenios,
                      w83b18s00 diferencias,
                      j7304s00 sectores
                WHERE centros.ccen_001 = actas.id_centro_016
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND centros.secc_001 = sectores.secc_004
                  --AND actas.f_baja_016 IS NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
             GROUP BY centros.secc_001,
                      sectores.desc_004,
                      centros.ccen_001,
                      centros.ccif_001,
                      centros.rsoc_001,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      totelec_016,
                      sindicatos.c_sindi_019,
                      sindicatos.siglas_019,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016,
                      actas.factu_016) consulta
  ORDER BY consulta.codconvenio,
            consulta.razon,
            consulta.nacta,
            consulta.territ,
            consulta.anoacta,
            consulta.ver,
            consulta.codsindicato ;

/

CREATE OR REPLACE FORCE VIEW w83b.w83bdetallecentrosindicato (nacta,
                                                              territ,
                                                              anoacta,
                                                              ver,
                                                              anoregdef,
                                                              nregdef,
                                                              felec,
                                                              cif,
                                                              sector,
                                                              razon,
                                                              ncentro,
                                                              convdesc,
                                                              totalelectores,
                                                              numdelegados,
                                                              sinddesc,
                                                              siglas,
                                                              codsindicato,
                                                              actatotal,
                                                              fechabaja,
                                                              fecharegistro,
                                                              nactacompleta
                                                             )
AS
   SELECT   consulta.nacta, consulta.territ, consulta.anoacta, consulta.ver,
            consulta.anoregdef, consulta.nregdef, consulta.felec,
            consulta.cif, consulta.sector, consulta.razon, consulta.ncentro,
            consulta.convdesc, consulta.totalelectores, consulta.numdelegados,
            consulta.sinddesc, consulta.siglas, consulta.codsindicato,
            consulta.actatotal, consulta.fechabaja, consulta.fecharegistro,
            consulta.nactacompleta
       FROM (SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b24s00 escrutinios,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = escrutinios.n_acta_024(+)
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024(+)
                  AND actas.c_territ_016 = escrutinios.c_territ_024(+)
                  AND actas.version_016 = escrutinios.version_024(+)
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      escrutinios.c_sindi_024,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                )
             UNION ALL
             SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (diferencias.n_delh_018 + diferencias.n_delm_018
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b18s00 diferencias,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = diferencias.n_acta_018(+)
                  AND actas.ano_acta_016 = diferencias.ano_acta_018(+)
                  AND actas.c_territ_016 = diferencias.c_territ_018(+)
                  AND actas.version_016 = diferencias.version_018(+)
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      diferencias.c_sindi_018,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                )) consulta
      WHERE consulta.ver =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.nacta = act.n_acta_016
                   AND consulta.anoacta = act.ano_acta_016
                   AND consulta.territ = c_territ_016
                   AND act.validada_016 = 1
                   AND act.n_acttot_016 IS NULL)
   ORDER BY consulta.nacta ASC,
            consulta.anoacta ASC,
            consulta.territ ASC,
            consulta.codsindicato ASC;
/


CREATE OR REPLACE FORCE VIEW w83b.w83bdetallecentrosindicatohist (nacta,
                                                                  territ,
                                                                  anoacta,
                                                                  ver,
                                                                  anoregdef,
                                                                  nregdef,
                                                                  felec,
                                                                  cif,
                                                                  sector,
                                                                  razon,
                                                                  ncentro,
                                                                  convdesc,
                                                                  totalelectores,
                                                                  numdelegados,
                                                                  sinddesc,
                                                                  siglas,
                                                                  codsindicato,
                                                                  actatotal,
                                                                  fechabaja,
                                                                  fecharegistro,
                                                                  nactacompleta,
                                                                  fechaactu
                                                                 )
AS
   SELECT   consulta.nacta, consulta.territ, consulta.anoacta, consulta.ver,
            consulta.anoregdef, consulta.nregdef, consulta.felec,
            consulta.cif, consulta.sector, consulta.razon, consulta.ncentro,
            consulta.convdesc, consulta.totalelectores, consulta.numdelegados,
            consulta.sinddesc, consulta.siglas, consulta.codsindicato,
            consulta.actatotal, consulta.fechabaja, consulta.fecharegistro,
            consulta.nactacompleta, consulta.fechaactu
       FROM (SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta,
                      actas.factu_016 AS fechaactu
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b24s00 escrutinios,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = escrutinios.n_acta_024(+)
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024(+)
                  AND actas.c_territ_016 = escrutinios.c_territ_024(+)
                  AND actas.version_016 = escrutinios.version_024(+)
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      escrutinios.c_sindi_024,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                ),
                      actas.factu_016
             UNION ALL
             SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
                      actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
                      actas.ano_regdef_016 AS anoregdef,
                      actas.n_regdef_016 AS nregdef,
                      actas.f_elecc_016 AS felec, centros.ccif_001 AS cif,
                      centros.secc_001 AS sector, centros.rsoc_001 AS razon,
                      centros.ncen_001 AS ncentro,
                      convenios.desc_013 AS convdesc,
                      actas.totelec_016 AS totalelectores,
                      SUM (diferencias.n_delh_018 + diferencias.n_delm_018
                          ) AS numdelegados,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.siglas_019 AS siglas,
                      sindicatos.c_sindi_019 AS codsindicato,
                      actas.n_acttot_016 AS actatotal,
                      actas.f_baja_016 AS fechabaja,
                      actas.fregdef_016 AS fecharegistro,
                      TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                          || actas.version_016
                         ) AS nactacompleta,
                      actas.factu_016 AS fechaactu
                 FROM w83b16s00 actas,
                      j7301s01 centros,
                      w83b13s00 convenios,
                      w83b18s00 diferencias,
                      w83b19s00 sindicatos
                WHERE actas.id_centro_016 = centros.ccen_001
                  AND actas.c_conv_016 = convenios.c_conv_013(+)
                  AND actas.n_acta_016 = diferencias.n_acta_018(+)
                  AND actas.ano_acta_016 = diferencias.ano_acta_018(+)
                  AND actas.c_territ_016 = diferencias.c_territ_018(+)
                  AND actas.version_016 = diferencias.version_018(+)
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
             GROUP BY actas.n_acta_016,
                      actas.c_territ_016,
                      actas.ano_acta_016,
                      actas.version_016,
                      actas.ano_regdef_016,
                      actas.n_regdef_016,
                      actas.f_elecc_016,
                      actas.c_conv_016,
                      centros.ccif_001,
                      centros.secc_001,
                      centros.rsoc_001,
                      centros.ncen_001,
                      convenios.desc_013,
                      actas.totelec_016,
                      diferencias.c_sindi_018,
                      sindicatos.desc_019,
                      sindicatos.siglas_019,
                      sindicatos.c_sindi_019,
                      actas.n_acttot_016,
                      actas.f_baja_016,
                      actas.fregdef_016,
                      TO_NUMBER (   actas.c_territ_016
                                 || actas.ano_acta_016
                                 || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                            1,  '00000'
                                             || TO_CHAR (actas.n_acta_016),
                                            2,  '0000'
                                             || TO_CHAR (actas.n_acta_016),
                                            3,  '000'
                                             || TO_CHAR (actas.n_acta_016),
                                            4, '00'
                                             || TO_CHAR (actas.n_acta_016),
                                            5, '0'
                                             || TO_CHAR (actas.n_acta_016),
                                            TO_CHAR (actas.n_acta_016)
                                           )
                                 || actas.version_016
                                ),
                      actas.factu_016) consulta
   ORDER BY consulta.nacta ASC,
            consulta.anoacta ASC,
            consulta.territ ASC,
            consulta.codsindicato ASC;
/
